(function () {
    let app = angular.module('purchase', []);

    app.directive('purchase', function () {
        return {
            restrict: 'E',
            templateUrl: 'templates/purchase.html',
            scope: {
            },
            controller: function ($scope, $rootScope) {
                $scope.items = Database.items;
                let ctrl = this;
                $scope.GetLocalized = Helpers.GetLocalized;

                Helpers.MovePropToIsolatedScope($rootScope, $scope, 'companyTier');
                Helpers.MovePropToIsolatedScope($rootScope, $scope, 'activeBuilding');

                Helpers.RootScopeWatchCollectionAndDestroy($scope, 'settings.office.workstations', workstations => {
                   ctrl.remainingWorkstations = $rootScope.activeBuilding.workstations - workstations.length;
                });

                this.clickWorkstation = (workstationType) => {
                    if(workstationType.price > $rootScope.settings.balance) {
                        $rootScope.showMessage(``, Helpers.GetLocalized('not_enough_money_this'));
                        return;
                    }

                    if (ctrl.remainingWorkstations > 0) {
                        $rootScope.placeWorkstation(workstationType);
                        $rootScope.view = '';
                    } else {
                        $rootScope.showMessage(null, Helpers.GetLocalized("no_more_workstations"));
                    }
                };

                this.previewItem = item => {
                    if(item.price > $rootScope.settings.balance) {
                        $rootScope.showMessage(``, Helpers.GetLocalized('not_enough_money_this'));
                        return;
                    }
                    if (item.tier <= $rootScope.companyTier) {
                        $rootScope.showPreview(null, item, item.width, item.height);
                        $rootScope.view = '';
                    }
                };

                let loadItems = () => {
                    ctrl.random = _.random(0, 1000);
                    ctrl.items = Helpers.Clone(Database.items).map(item => {
                        item.popoverText = Helpers.GetItemPopover(item, true);
                        item.url = Helpers.PrepareItemPath(item.imagePath);
                        return item;
                    });

                    ctrl.workstations = Helpers.Clone(Database.workstationTypes).map(workstationType => {
                        let result = [];
                        if (workstationType.tier > GetRootScope().companyTier) {
                            result.push(`<strong>${Helpers.GetLocalized('unlocked_at_tier', {tier: workstationType.tier })}</strong>`);
                        }

                        result.push(Helpers.GetLocalized('office_bonus_amount', {bonus :workstationType.bonus + "%"}));

                        result.push(Helpers.GetLocalized('price_amount', {amount: numeral(workstationType.price).format(Configuration.CURRENCY_FORMAT)}));
                        workstationType.popoverText = `<div class="text-center">${ _.join(result, '<br />')}</div>`;

                        return workstationType;
                    });
                };
                Helpers.RootScopeWatchAndDestroy($scope, 'companyTier', () => loadItems());
            },
            controllerAs: 'ctrl'
        };
    });
})();
